/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.BlockLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;

public final class BlockLightEngine
extends LightEngine<BlockLightSectionStorage.BlockDataLayerStorageMap, BlockLightSectionStorage> {
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public BlockLightEngine(LightChunkGetter p_75492_) {
        this(p_75492_, new BlockLightSectionStorage(p_75492_));
    }

    @VisibleForTesting
    public BlockLightEngine(LightChunkGetter p_278252_, BlockLightSectionStorage p_278255_) {
        super(p_278252_, p_278255_);
    }

    @Override
    protected void checkNode(long p_285169_) {
        int $$4;
        long $$1 = SectionPos.blockToSection(p_285169_);
        if (!((BlockLightSectionStorage)this.storage).storingLightForSection($$1)) {
            return;
        }
        BlockState $$2 = this.getState(this.mutablePos.set(p_285169_));
        int $$3 = this.getEmission(p_285169_, $$2);
        if ($$3 < ($$4 = ((BlockLightSectionStorage)this.storage).getStoredLevel(p_285169_))) {
            ((BlockLightSectionStorage)this.storage).setStoredLevel(p_285169_, 0);
            this.enqueueDecrease(p_285169_, LightEngine.QueueEntry.decreaseAllDirections($$4));
        } else {
            this.enqueueDecrease(p_285169_, PULL_LIGHT_IN_ENTRY);
        }
        if ($$3 > 0) {
            this.enqueueIncrease(p_285169_, LightEngine.QueueEntry.increaseLightFromEmission($$3, BlockLightEngine.isEmptyShape($$2)));
        }
    }

    @Override
    protected void propagateIncrease(long p_285500_, long p_285410_, int p_285492_) {
        BlockState $$3 = null;
        for (Direction $$4 : PROPAGATION_DIRECTIONS) {
            int $$6;
            int $$7;
            long $$5;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(p_285410_, $$4) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection($$5 = BlockPos.offset(p_285500_, $$4))) || ($$7 = p_285492_ - 1) <= ($$6 = ((BlockLightSectionStorage)this.storage).getStoredLevel($$5))) continue;
            this.mutablePos.set($$5);
            BlockState $$8 = this.getState(this.mutablePos);
            int $$9 = p_285492_ - this.getOpacity($$8, this.mutablePos);
            if ($$9 <= $$6) continue;
            if ($$3 == null) {
                BlockState blockState = $$3 = LightEngine.QueueEntry.isFromEmptyShape(p_285410_) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(p_285500_));
            }
            if (this.shapeOccludes(p_285500_, $$3, $$5, $$8, $$4)) continue;
            ((BlockLightSectionStorage)this.storage).setStoredLevel($$5, $$9);
            if ($$9 <= 1) continue;
            this.enqueueIncrease($$5, LightEngine.QueueEntry.increaseSkipOneDirection($$9, BlockLightEngine.isEmptyShape($$8), $$4.getOpposite()));
        }
    }

    @Override
    protected void propagateDecrease(long p_285435_, long p_285230_) {
        int $$2 = LightEngine.QueueEntry.getFromLevel(p_285230_);
        for (Direction $$3 : PROPAGATION_DIRECTIONS) {
            int $$5;
            long $$4;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(p_285230_, $$3) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection($$4 = BlockPos.offset(p_285435_, $$3))) || ($$5 = ((BlockLightSectionStorage)this.storage).getStoredLevel($$4)) == 0) continue;
            if ($$5 <= $$2 - 1) {
                BlockState $$6 = this.getState(this.mutablePos.set($$4));
                int $$7 = this.getEmission($$4, $$6);
                ((BlockLightSectionStorage)this.storage).setStoredLevel($$4, 0);
                if ($$7 < $$5) {
                    this.enqueueDecrease($$4, LightEngine.QueueEntry.decreaseSkipOneDirection($$5, $$3.getOpposite()));
                }
                if ($$7 <= 0) continue;
                this.enqueueIncrease($$4, LightEngine.QueueEntry.increaseLightFromEmission($$7, BlockLightEngine.isEmptyShape($$6)));
                continue;
            }
            this.enqueueIncrease($$4, LightEngine.QueueEntry.increaseOnlyOneDirection($$5, false, $$3.getOpposite()));
        }
    }

    private int getEmission(long p_285243_, BlockState p_284973_) {
        int $$2 = p_284973_.getLightEmission();
        if ($$2 > 0 && ((BlockLightSectionStorage)this.storage).lightOnInSection(SectionPos.blockToSection(p_285243_))) {
            return $$2;
        }
        return 0;
    }

    @Override
    public void propagateLightSources(ChunkPos p_285274_) {
        this.setLightEnabled(p_285274_, true);
        LightChunk $$1 = this.chunkSource.getChunkForLighting(p_285274_.x, p_285274_.z);
        if ($$1 != null) {
            $$1.findBlockLightSources((p_285266_, p_285452_) -> {
                int $$2 = p_285452_.getLightEmission();
                this.enqueueIncrease(p_285266_.asLong(), LightEngine.QueueEntry.increaseLightFromEmission($$2, BlockLightEngine.isEmptyShape(p_285452_)));
            });
        }
    }
}

